// Movement // Radnen 2008 // Sphere v1.14 //

const EAST = COMMAND_MOVE_EAST;
const NORTH = COMMAND_MOVE_NORTH;
const SOUTH = COMMAND_MOVE_SOUTH;
const WEST = COMMAND_MOVE_WEST;

function Move(name, tiles, direction_command, face_command)
{
	if (face_command == undefined)
	{
		if (direction_command == COMMAND_MOVE_NORTH) face_command = COMMAND_FACE_NORTH;
		if (direction_command == COMMAND_MOVE_SOUTH) face_command = COMMAND_FACE_SOUTH;
		if (direction_command == COMMAND_MOVE_EAST) face_command = COMMAND_FACE_EAST;
		if (direction_command == COMMAND_MOVE_WEST) face_command = COMMAND_FACE_WEST;
		if (direction_command == COMMAND_WAIT) face_command = null;
	}
	
	if (!IsObstructed(name, direction_command))
	{
		if (face_command != null) QueuePersonCommand(name, face_command, true);
		for (var i = 0; i < tiles; ++i)
		{
			for (var j = 0; j < 1; ++j)
			{
				QueuePersonCommand(name, direction_command, false);
			}
		}
	}
}

function RandomWalk(name)
{
	var directions = [COMMAND_MOVE_NORTH, COMMAND_MOVE_SOUTH, COMMAND_MOVE_EAST, COMMAND_MOVE_WEST];
	var direction = Math.floor(Math.random() * (directions.length));
	
	Move(name, 1, directions[direction]);
	Move(name, 1, COMMAND_WAIT);
}

function IsObstructed(name, direction)
{
	const X = GetPersonX(name);
	const Y = GetPersonY(name);
	switch(direction)
	{
		case COMMAND_MOVE_NORTH:
			if (IsPersonObstructed(name, X, Y-8)) return true;
		break;
		case COMMAND_MOVE_SOUTH:
			if (IsPersonObstructed(name, X, Y+8)) return true;
		break;
		case COMMAND_MOVE_EAST:
			if (IsPersonObstructed(name, X+8, Y)) return true;
		break;
		case COMMAND_MOVE_WEST:
			if (IsPersonObstructed(name, X-8, Y)) return true;
		break;
		default: return false; break;
	}
}

function MoveToLocation(name, x, y, moves)
{
	var Path = MovePath(name, -1, -1, 0, x, y);
	if (moves == undefined) moves = Path.length;
	Path = Path.substr(0, moves);
	for (var i = 0; i < Path.length; ++i)
	{
		switch (Path.charAt(i))
		{
			case "E": Move(name, 1, EAST); break;
			case "N": Move(name, 1, NORTH); break;
			case "S": Move(name, 1, SOUTH); break;
			case "W": Move(name, 1, WEST); break;
			case "F": break;
		}
	}
}

function MoveMe(tiles)
{
	var name = GetCurrentPerson();
	var direction = GetPersonDirection(name);
	switch (direction)
	{
		case "north": Move(name, tiles, NORTH); break;
		case "south": Move(name, tiles, SOUTH); break;
		case "east": Move(name, tiles, EAST); break;
		case "west": Move(name, tiles, WEST); break;
	}
}